package com.vf106.tools.utils;

import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;

/**
 * @author syb
 * @description：
 * @date : 2024/3/7 15:19
 */
public class WarningUtils {

    private static final byte[] openIn = {'i', 'n'};

    public static void writeGPIO101Direction() {
        FileOutputStream fBlue;
        try {
            String GPIO101_DIRECTION = "/sys/class/gpio/gpio101/direction";
            fBlue = new FileOutputStream(GPIO101_DIRECTION);
            fBlue.write(openIn);
            fBlue.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void writeGPIO100Direction() {
        FileOutputStream fBlue;
        try {
            String GPIO100_DIRECTION = "/sys/class/gpio/gpio100/direction";
            fBlue = new FileOutputStream(GPIO100_DIRECTION);
            fBlue.write(openIn);
            fBlue.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String readGPIO101Value() {
        BufferedReader reader = null;
        try {
            String GPIO101_VALUE = "/sys/class/gpio/gpio101/value";
            reader = new BufferedReader(new FileReader(GPIO101_VALUE));
            return reader.readLine();
        } catch (IOException e) {
            e.printStackTrace();
            return null;
        } finally {
            if (reader != null) {
                try {
                    reader.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static String readGPIO100Value() {
        BufferedReader reader = null;
        try {
            String GPIO100_VALUE = "/sys/class/gpio/gpio100/value";
            reader = new BufferedReader(new FileReader(GPIO100_VALUE));
            return reader.readLine();
        } catch (IOException e) {
            e.printStackTrace();
            return null;
        } finally {
            if (reader != null) {
                try {
                    reader.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

}
